<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LabNotebookTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'research_team_id',
        'creator_id',
        'title',
        'description',
        'body',
    ];

    /**
     * Get the research team that owns the template.
     */
    public function researchTeam(): BelongsTo
    {
        return $this->belongsTo(ResearchTeam::class);
    }

    /**
     * Get the user who created the template.
     */
    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
}
