<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OnboardingChecklistItem extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'research_team_id',
        'title',
        'order',
    ];

    /**
     * Get the research team that the checklist item belongs to.
     */
    public function researchTeam(): BelongsTo
    {
        return $this->belongsTo(ResearchTeam::class);
    }
}
