<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Payment extends Model
{
    use HasFactory;

    protected $fillable = [
        'uuid',
        'user_id',
        'payable_id',
        'payable_type',
        'amount',
        'gateway_name',
        'transaction_id',
        'status',
        'settlement_status',
        'settled_at',
        'paid_at',
        'meta',
    ];

    protected $casts = [
        'paid_at' => 'datetime',
        'meta' => 'array',
    ];
    // [NEW] Automatically create a log when a payment is created.
    protected static function booted()
    {
        static::created(function ($payment) {
            $payment->logs()->create([
                'user_id' => $payment->user_id,
                'action' => 'created',
                'description' => 'تراکنش پرداخت ایجاد شد.',
            ]);
        });
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function payable(): MorphTo
    {
        return $this->morphTo();
    }
    // [NEW] Relationships
    public function notes(): HasMany
    {
        return $this->hasMany(PaymentNote::class)->latest();
    }

    public function logs(): HasMany
    {
        return $this->hasMany(PaymentLog::class)->latest();
    }
}
