<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Spatie\Permission\Models\Permission as SpatiePermission;

class Permission extends SpatiePermission
{
    /**
     * [NEW] The users that have been granted this permission in various projects.
     * این رابطه، تمام کاربرانی که این دسترسی را در طرح‌های مختلف دارند، برمی‌گرداند.
     */
    public function usersInProjects(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'project_user_permission', 'permission_id', 'user_id')
            ->withPivot('project_id')
            ->withTimestamps();
    }
}
