<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PersonalNote extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'note_code',
        'title',
        'body',
    ];

    /**
     * Get the user that owns the note.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the attachments for the note.
     */
    public function attachments(): HasMany
    {
        return $this->hasMany(PersonalNoteAttachment::class);
    }
}
