<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PersonalNoteAttachment extends Model
{
    use HasFactory;

    protected $fillable = [
        'personal_note_id',
        'user_id',
        'file_path',
        'file_name',
        'file_size',
        'mime_type',
    ];

    /**
     * Get the personal note that owns the attachment.
     */
    public function personalNote(): BelongsTo
    {
        return $this->belongsTo(PersonalNote::class);
    }
}
