<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;

/**
 * این مدل به عنوان یک مدل Pivot سفارشی برای جدول واسط 'project_inventory_item' عمل می‌کند.
 * استفاده از Pivot به ما اجازه می‌دهد تا منطق خاصی را برای این رابطه تعریف کنیم.
 */
class ProjectInventoryItem extends Pivot
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'project_inventory_item';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'project_id',
        'inventory_item_id',
        'max_allowed_quantity',
        'total_consumed_quantity',
    ];

    /**
     * دریافت طرح مرتبط با این رکورد بودجه.
     */
    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    /**
     * دریافت آیتم انبار مرتبط با این رکورد بودجه.
     */
    public function inventoryItem()
    {
        return $this->belongsTo(InventoryItem::class);
    }
}
