<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PurchaseRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'request_code',
        'requester_id',
        'institution_id',
        'project_id',
        'status',
        'notes',
        'priority',
        'approver_id',
        'approved_at',
        'final_response_id',
        'assigned_supplier_id'

    ];


    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        // این خط به لاراول می‌گوید که این ستون را به صورت خودکار به یک آبجکت تاریخ تبدیل کند
        'approved_at' => 'datetime',
    ];

    public function requester(): BelongsTo { return $this->belongsTo(User::class, 'requester_id'); }
    public function project(): BelongsTo { return $this->belongsTo(Project::class); }
    public function items(): HasMany { return $this->hasMany(PurchaseRequestItem::class); }
    /**
     * Get the user who needs to approve the request.
     * این متد جدید، رابطه با تایید کننده را تعریف می‌کند.
     */
    public function approver(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approver_id');
    }

    /**
     * Get all of the responses for the purchase request.
     */
    public function responses(): HasMany
    {
        return $this->hasMany(SupplierResponse::class);
    }

    /**
     * Get the final approved supplier response for the request.
     */
    public function finalResponse(): BelongsTo
    {
        return $this->belongsTo(SupplierResponse::class, 'final_response_id');
    }

    /**
     * Get the supplier this request is specifically assigned to.
     */
    public function assignedSupplier(): BelongsTo
    {
        return $this->belongsTo(Supplier::class, 'assigned_supplier_id');
    }

    public function shipments()
    {
        return $this->hasMany(Shipment::class);
    }
}

