<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PurchaseRequestItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'purchase_request_id',
        'item_name',
        'supplier_id',
        'catalog_number',
        'quantity',
        'unit',
        'estimated_cost_per_unit',
        'description',
        // فیلدهای جدید
        'is_accepted',
        'supplied_quantity',
        'price_per_unit',
        'supplier_notes',
        'status',
        'final_supplier_response_item_id'
    ];

    public function request(): BelongsTo {
        return $this->belongsTo(PurchaseRequest::class);
    }

    public function supplier(): BelongsTo {
        return $this->belongsTo(Supplier::class);
    }

    /**
     * [FIX] Get the purchase request that this item belongs to.
     * This is the missing relationship that caused the error.
     */
    public function purchaseRequest(): BelongsTo
    {
        return $this->belongsTo(PurchaseRequest::class);
    }
    /**
     * Get the final chosen supplier response item for this request item.
     * این متد جدید، رابطه "تعلق داشتن به" را با مدل SupplierResponseItem تعریف می‌کند.
     */
    public function finalResponseItem(): BelongsTo
    {
        return $this->belongsTo(SupplierResponseItem::class, 'final_supplier_response_item_id');
    }
}

