<?php
//
//namespace App\Models;
//
//use Illuminate\Database\Eloquent\Factories\HasFactory;
//use Illuminate\Database\Eloquent\Model;
//use Illuminate\Database\Eloquent\Relations\BelongsTo;
//use Illuminate\Database\Eloquent\Relations\HasMany;
//
//class Shipment extends Model
//{
//    use HasFactory;
//
//    protected $fillable = [
//        'supplier_id',
//        'shipping_method',
//        'tracking_code',
//        'dispatched_at',
//    ];
//
//    protected $casts = [
//        'dispatched_at' => 'datetime',
//        'delivered_at' => 'datetime',
//    ];
//
//    public function supplier(): BelongsTo
//    {
//        return $this->belongsTo(Supplier::class);
//    }
//
//    public function items(): HasMany
//    {
//        return $this->hasMany(SupplierResponseItem::class);
//    }
//
//    public function purchaseRequest(): BelongsTo
//    {
//        return $this->belongsTo(PurchaseRequest::class);
//    }
//}
//


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Shipment extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'supplier_id',
        'purchase_request_id',
        'shipping_method',
        'tracking_code',
        'notes',
        'status',
        'dispatched_at',
        'delivered_at',
    ];


    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'dispatched_at' => 'datetime',
        'delivered_at' => 'datetime',
    ];

    /**
     * Get the supplier that owns the shipment.
     */
    public function supplier(): BelongsTo
    {
        return $this->belongsTo(Supplier::class);
    }

    /**
     * Get the purchase request that the shipment belongs to.
     */
    public function purchaseRequest(): BelongsTo
    {
        return $this->belongsTo(PurchaseRequest::class);
    }

    /**
     * Get all of the items for the shipment.
     * This now points to the pivot model.
     */
    public function items(): HasMany
    {
        return $this->hasMany(ShipmentItem::class);
    }
}
