<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SupplierResponseItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'supplier_response_id',
        'purchase_request_item_id',
        'is_accepted',
        'supplied_quantity',
        'price_per_unit',
        'supplier_notes',
        'shipment_id', // فیلد جدید
    ];

    public function response(): BelongsTo
    {
        return $this->belongsTo(SupplierResponse::class, 'supplier_response_id');
    }

    public function originalItem(): BelongsTo
    {
        return $this->belongsTo(PurchaseRequestItem::class, 'purchase_request_item_id');
    }

    public function shipment(): BelongsTo
    { return $this->belongsTo(Shipment::class); }

    public function shipmentItems()
    {
        return $this->hasMany(ShipmentItem::class);
    }
}

