<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TeamAnnouncement extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'research_team_id',
        'user_id',
        'title',
        'body',
        'level',
        'is_pinned',
        'attachment_path', // [NEW]
        'attachment_name', // [NEW]
        'attachment_size', // [NEW]
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_pinned' => 'boolean',
    ];

    /**
     * Get the research team that the announcement belongs to.
     */
    public function researchTeam(): BelongsTo
    {
        return $this->belongsTo(ResearchTeam::class);
    }

    /**
     * Get the user who created the announcement.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    public function team(): BelongsTo
    {
        return $this->belongsTo(ResearchTeam::class, 'research_team_id');
    }
}
