<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Laravel\Jetstream\TeamInvitation as JetstreamTeamInvitation;

class TeamInvitation extends JetstreamTeamInvitation
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'team_id', // ما از این ستون برای research_team_id استفاده می‌کنیم
        'email',
        'role',
        'token',
        'expires_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'expires_at' => 'datetime',
    ];

    /**
     * [OVERRIDDEN] Get the team that the invitation belongs to.
     * ما این متد را بازنویسی می‌کنیم تا به مدل ResearchTeam ما اشاره کند.
     */
    public function team(): BelongsTo
    {
        // ستون team_id در جدول ما به ID در جدول research_teams اشاره دارد
        return $this->belongsTo(ResearchTeam::class, 'team_id');
    }
}
