<?php

namespace App\Notifications\Channels;

use Illuminate\Notifications\Notification;
use Trez\RayganSms\Facades\RayganSms;

class RayganSmsChannel
{
    /**
     * Send the given notification.
     *
     * @param  mixed  $notifiable
     * @param  \Illuminate\Notifications\Notification  $notification
     * @return void
     */
    public function send($notifiable, Notification $notification)
    {
        // 1. ابتدا متد toRayganSms را روی کلاس اعلان فراخوانی می‌کنیم تا متن پیامک را دریافت کنیم
        $message = $notification->toRayganSms($notifiable);

        // اگر متد toRayganSms چیزی برنگرداند، عملیات متوقف می‌شود
        if (!$message) {
            return;
        }

        // 2. سپس، متد routeNotificationForRayganSms را روی مدل کاربر (notifiable) فراخوانی می‌کنیم
        // تا شماره تلفن گیرنده را دریافت کنیم
        $receptor = $notifiable->routeNotificationFor('RayganSms', $notification);

        // اگر شماره تلفنی وجود نداشت، عملیات متوقف می‌شود
        if (!$receptor) {
            return;
        }

        // 3. در نهایت، پیامک را با استفاده از پکیج ارسال می‌کنیم
        try {
            RayganSms::sendMessage($receptor, $message);
        } catch (\Exception $e) {
            // در اینجا می‌توانید خطاها را لاگ کنید
             Log::error('SMS sending failed: ' . $e->getMessage());
        }
    }
}
