<?php

namespace App\Notifications;

use App\Models\Shipment;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ConfirmDeliveryReminder extends Notification implements ShouldQueue
{
    use Queueable;

    protected Shipment $shipment;

    /**
     * Create a new notification instance.
     */
    public function __construct(Shipment $shipment)
    {
        $this->shipment = $shipment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database']; // We'll start with database notifications
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $requestCode = $this->shipment->purchaseRequest->request_code;
        $daysRemaining = now()->diffInDays($this->shipment->dispatched_at->addDays(14));

        return [
            'title' => 'یادآوری: تایید دریافت کالا',
            'message' => "بسته ارسالی برای درخواست خرید {$requestCode} در انتظار تایید شماست. در صورت عدم اقدام تا {$daysRemaining} روز دیگر، دریافت کالا به صورت خودکار تایید خواهد شد.",
            'link' => route('purchase-requests.index'), // Link to the purchase request page
            'icon' => 'lucide-package-check',
        ];
    }
}
