<?php

namespace App\Notifications;

use App\Models\InventoryItem;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ExpirationDateAlert extends Notification
{
    use Queueable;

    protected $item;

    /**
     * Create a new notification instance.
     */
    public function __construct(InventoryItem $item)
    {
        $this->item = $item;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $expirationDate = \Carbon\Carbon::parse($this->item->expiration_date)->format('Y/m/d');
        return [
            'message' => "تاریخ انقضای آیتم '{$this->item->name}' (SKU: {$this->item->sku}) در تاریخ {$expirationDate} به پایان می‌رسد.",
            'url' => route('inventory.index'),
        ];
    }
}

