<?php

namespace App\Notifications;

use App\Models\InventoryItem;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LowStockAlert extends Notification
{
    use Queueable;

    protected $item;

    /**
     * Create a new notification instance.
     */
    public function __construct(InventoryItem $item)
    {
        $this->item = $item;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        // ما این اعلان را فقط در پایگاه داده ذخیره می‌کنیم
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        // این داده‌ها در ستون 'data' جدول notifications ذخیره خواهند شد
        return [
            'message' => "موجودی آیتم '{$this->item->name}' (SKU: {$this->item->sku}) به حد آستانه رسیده است. لطفاً برای خرید مجدد اقدام نمایید.",
            'url' => route('inventory.index'), // لینک به صفحه مدیریت انبار
        ];
    }
}

