<?php

namespace App\Notifications;

use App\Models\ChatMessage;
use App\Models\ChatRoom;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewChatMessageNotification extends Notification
{
    use Queueable;

    public ChatMessage $message;
    public ChatRoom $chatRoom;
    public User $sender;

    /**
     * Create a new notification instance.
     */
    public function __construct(ChatMessage $message, ChatRoom $chatRoom, User $sender)
    {
        $this->message = $message;
        $this->chatRoom = $chatRoom;
        $this->sender = $sender;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        // ما اعلان را از طریق ایمیل و همچنین پایگاه داده (برای نمایش در برنامه) ارسال می‌کنیم
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $chatUrl = route('chat.index', ['chatRoomId' => $this->chatRoom->id]);

        return (new MailMessage)
            ->subject('پیام جدید از طرف ' . $this->sender->name)
            ->greeting('سلام ' . $notifiable->name . ',')
            ->line('شما یک پیام جدید از طرف ' . $this->sender->name . ' در گفتگوی "' . $this->chatRoom->name . '" دریافت کرده‌اید.')
            ->line('متن پیام: "' . $this->message->body . '"')
            ->action('مشاهده گفتگو', $chatUrl);
    }

    /**
     * Get the array representation of the notification for database storage.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'icon' => 'message-circle', // نام آیکون از Lucide Icons
            'title' => 'پیام جدید از ' . $this->sender->name,
            'message' => 'در گفتگوی "' . $this->chatRoom->name . '": ' . \Illuminate\Support\Str::limit($this->message->body, 50),
            'url' => route('chat.index', ['chatRoomId' => $this->chatRoom->id]),
        ];
    }
}
