<?php

namespace App\Notifications;

use App\Models\ProjectAnnouncement;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewProjectAnnouncement extends Notification
{
    use Queueable;

    public ProjectAnnouncement $announcement;
    public User $creator;

    /**
     * Create a new notification instance.
     */
    public function __construct(ProjectAnnouncement $announcement, User $creator)
    {
        $this->announcement = $announcement;
        $this->creator = $creator;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $projectUrl = route('projects.show', $this->announcement->project);

        return (new MailMessage)
            ->subject('اطلاعیه جدید در طرح: ' . $this->announcement->project->title)
            ->greeting('سلام ' . $notifiable->name . ',')
            ->line('یک اطلاعیه جدید توسط ' . $this->creator->name . ' در طرح "' . $this->announcement->project->title . '" ثبت شده است.')
            ->line('**' . $this->announcement->title . '**')
            ->line($this->announcement->body)
            ->action('مشاهده جزئیات طرح', $projectUrl);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'icon' => 'megaphone', // نام آیکون از Lucide Icons
            'title' => 'اطلاعیه جدید در طرح',
            'message' => 'اطلاعیه "' . $this->announcement->title . '" در طرح "' . $this->announcement->project->title . '" ثبت شد.',
            'url' => route('projects.show', $this->announcement->project),
        ];
    }
}
