<?php

namespace App\Notifications;

use App\Models\Task;
use App\Models\User;
use Illuminate\Bus\Queueable;
use App\Notifications\Channels\RayganSmsChannel;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TaskAssignedNotification extends Notification
{
    use Queueable;

    public Task $task;
    public User $assigner;

    /**
     * Create a new notification instance.
     */
    public function __construct(Task $task, User $assigner)
    {
        $this->task = $task;
        $this->assigner = $assigner;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        // ما اعلان را از طریق ایمیل و همچنین پایگاه داده (برای نمایش در برنامه) ارسال می‌کنیم
        return ['mail', 'database', RayganSmsChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $projectUrl = route('projects.show', $this->task->project);

        return (new MailMessage)
            ->subject('وظیفه جدیدی به شما محول شد: ' . $this->task->title)
            ->greeting('سلام ' . $notifiable->name . ',')
            ->line('یک وظیفه جدید توسط ' . $this->assigner->name . ' در طرح "' . $this->task->project->title . '" به شما محول شده است.')
            ->line('عنوان وظیفه: ' . $this->task->title)
            ->action('مشاهده جزئیات طرح', $projectUrl)
            ->line('از همکاری شما سپاسگزاریم!');
    }
    /**
     * [NEW] Get the RayganSms representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toRayganSms($notifiable)
    {
        // متن پیامک را به صورت خلاصه و مناسب آماده می‌کنیم
        return "وظیفه جدیدی به شما محول شد: " . $this->task->title . "\nBenchSync";
    }

    /**
     * Get the array representation of the notification for database storage.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'icon' => 'clipboard-list', // نام آیکون از Lucide Icons
            'title' => 'وظیفه جدید برای شما',
            'message' => 'وظیفه "' . $this->task->title . '" توسط ' . $this->assigner->name . ' به شما محول شد.',
            'url' => route('projects.show', $this->task->project),
        ];
    }
}
