<?php

namespace App\Notifications;

use App\Models\Task;
use App\Models\User;
use App\Notifications\Channels\RayganSmsChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TaskStatusChangedNotification extends Notification
{
    use Queueable;

    public Task $task;
    public User $changer; // کاربری که وضعیت را تغییر داده است
    public string $oldStatus;

    /**
     * Create a new notification instance.
     */
    public function __construct(Task $task, User $changer, string $oldStatus)
    {
        $this->task = $task;
        $this->changer = $changer;
        $this->oldStatus = $oldStatus;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database',RayganSmsChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $projectUrl = route('projects.show', $this->task->project);

        return (new MailMessage)
            ->subject('تغییر وضعیت وظیفه: ' . $this->task->title)
            ->greeting('سلام ' . $notifiable->name . ',')
            ->line('وضعیت وظیفه "' . $this->task->title . '" در طرح "' . $this->task->project->title . '" توسط ' . $this->changer->name . ' تغییر کرد.')
            ->line('وضعیت قبلی: ' . $this->oldStatus)
            ->line('وضعیت جدید: ' . $this->task->status)
            ->action('مشاهده جزئیات طرح', $projectUrl);
    }

    public function toRayganSms($notifiable)
    {
        // متن پیامک را به صورت خلاصه و مناسب آماده می‌کنیم
        return "وظیفه جدیدی به شما محول شد: " . $this->task->title . "\nBenchSync";
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'icon' => 'refresh-cw', // نام آیکون از Lucide Icons
            'title' => 'تغییر وضعیت وظیفه',
            'message' => 'وضعیت وظیفه "' . $this->task->title . '" به ' . $this->task->status . ' تغییر کرد.',
            'url' => route('projects.show', $this->task->project),
        ];
    }
}
