<?php

namespace App\Notifications;

use App\Models\TeamInvitation;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\URL;

class TeamInvitationNotification extends Notification
{
    use Queueable;

    /**
     * The team invitation instance.
     *
     * @var \App\Models\TeamInvitation
     */
    public $invitation;

    /**
     * Create a new notification instance.
     */
    public function __construct(TeamInvitation $invitation)
    {
        $this->invitation = $invitation;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail']; // در آینده می‌توان 'database' را نیز اضافه کرد
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        // ایجاد لینک منحصر به فرد برای پذیرش دعوت
        $acceptUrl = URL::signedRoute('invitations.accept', ['token' => $this->invitation->token]);

        return (new MailMessage)
            ->subject('دعوت‌نامه عضویت در تیم: ' . $this->invitation->team->name)
            ->greeting('سلام!')
            ->line('شما برای عضویت در تیم تحقیقاتی "' . $this->invitation->team->name . '" در پلتفرم BenchSync دعوت شده‌اید.')
            ->line('نقش پیشنهادی برای شما: ' . $this->invitation->role)
            ->action('پذیرش دعوت‌نامه', $acceptUrl)
            ->line('اگر شما منتظر چنین دعوتی نبوده‌اید، می‌توانید این ایمیل را نادیده بگیرید.');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            // در آینده می‌توان اطلاعات لازم برای نمایش در مرکز اعلان‌ها را اینجا اضافه کرد
        ];
    }
}
