<?php

namespace App\Notifications;

use App\Models\InventoryTransfer;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TransferRejectedNotification extends Notification
{
    use Queueable;

    protected $transfer;

    /**
     * Create a new notification instance.
     */
    public function __construct(InventoryTransfer $transfer)
    {
        $this->transfer = $transfer;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => "حواله انبار با کد {$this->transfer->transfer_code} که برای تیم {$this->transfer->destinationTeam->name} ارسال کرده بودید، رد شد. موجودی آیتم‌ها به انبار شما بازگردانده شد.",
            'url' => route('inventory.transfers.index'),
        ];
    }
}
