<?php

namespace App\Notifications;

use App\Models\Task;
use App\Models\TaskComment;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class UserMentionedInCommentNotification extends Notification
{
    use Queueable;

    public Task $task;
    public TaskComment $comment;
    public User $commenter;

    /**
     * Create a new notification instance.
     */
    public function __construct(Task $task, TaskComment $comment, User $commenter)
    {
        $this->task = $task;
        $this->comment = $comment;
        $this->commenter = $commenter;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $projectUrl = route('projects.show', $this->task->project);

        return (new MailMessage)
            ->subject($this->commenter->name . ' در یک نظر به شما اشاره کرد')
            ->greeting('سلام ' . $notifiable->name . ',')
            ->line($this->commenter->name . ' در نظری برای وظیفه "' . $this->task->title . '" به شما اشاره کرده است.')
            ->line('متن نظر: "' . $this->comment->body . '"')
            ->action('مشاهده جزئیات طرح', $projectUrl);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'icon' => 'at-sign', // نام آیکون از Lucide Icons
            'title' => 'شما mention شدید',
            'message' => $this->commenter->name . ' در نظری برای وظیفه "' . $this->task->title . '" به شما اشاره کرد.',
            'url' => route('projects.show', $this->task->project),
        ];
    }
}
