<?php

namespace App\Notifications;

use App\Models\LabNotebookComment;
use App\Models\LabNotebookEntry;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Str;
use Illuminate\Notifications\Notification;

class YouWereMentionedInComment extends Notification
{
//    use Queueable;

    public LabNotebookComment $comment;
    public LabNotebookEntry $entry;

    /**
     * Create a new notification instance.
     */
    public function __construct(LabNotebookComment $comment, LabNotebookEntry $entry)
    {
        $this->comment = $comment;
        $this->entry = $entry;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        // We want to send both an email and save it to the database.
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $url = route('entries.edit', $this->entry);

        return (new MailMessage)
            ->subject('شما در یک نظر منشن شدید')
            ->greeting('سلام!')
            ->line("{$this->comment->user->name} در نظری برای یادداشت '{$this->entry->title}' به شما اشاره کرده است.")
            ->line("متن نظر: \"{$this->comment->body}\"")
            ->action('مشاهده یادداشت', $url)
            ->line('از اینکه از Benchsync استفاده می‌کنید متشکریم!');
    }

    /**
     * Get the array representation of the notification for database storage.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'commenter_id' => $this->comment->user->id,
            'commenter_name' => $this->comment->user->name,
            'entry_id' => $this->entry->id,
            'entry_title' => $this->entry->title,
            'comment_id' => $this->comment->id,
            'comment_body' => Str::limit($this->comment->body, 100),
            'url' => route('entries.edit', $this->entry),
        ];
    }
}
