<?php

namespace App\Observers;

use App\Models\InventoryItem;

class InventoryItemObserver
{
    /**
     * Handle the InventoryItem "updated" event.
     */
    public function updated(InventoryItem $inventoryItem): void
    {
        // ما بررسی می‌کنیم که آیا ستون 'quantity' تغییر کرده و مقدار آن افزایش یافته است یا خیر
        if ($inventoryItem->isDirty('quantity') && $inventoryItem->quantity > $inventoryItem->getOriginal('quantity')) {
            // حالا بررسی می‌کنیم که آیا موجودی جدید از حد آستانه بیشتر شده است یا خیر
            if ($inventoryItem->minimum_stock_level && $inventoryItem->quantity > $inventoryItem->minimum_stock_level) {
                // اگر هر دو شرط برقرار بود، تمام رکوردهای تایید هشدار مربوط به این آیتم را حذف می‌کنیم
                $inventoryItem->acknowledgements()->delete();
            }
        }
    }
}

