<?php
////
////namespace App\Policies;
////
////use App\Models\Equipment;
////use App\Models\User;
////use Illuminate\Auth\Access\Response;
////
////class EquipmentPolicy
////{
////    /**
////     * Perform pre-authorization checks.
////     */
////    public function before(User $user, string $ability): bool|null
////    {
////        if ($user->hasRole('super_admin')) {
////            return true;
////        }
////        return null;
////    }
////
////    /**
////     * [UPDATED] Determine whether the user can view any models.
////     */
////    public function viewAny(User $user): bool
////    {
////        // [FIX] استفاده از Accessor جدید
////        return $user->researchTeams()->wherePivot('role', 'admin')->exists() || $user->manager_of_calibration;
////    }
////
////    /**
////     * [UPDATED] Determine whether the user can view the model.
////     */
////    public function view(User $user, Equipment $equipment): bool
////    {
////        if ($user->id === $equipment->manager_id) {
////            return true;
////        }
////        // [FIX] استفاده از Accessor جدید
////        if ($equipment->manager && $user->id === $equipment->manager->calibration_manager_id) {
////            return true;
////        }
////        return false;
////    }
////
////    /**
////     * [UPDATED] Determine whether the user can create models.
////     */
////    public function create(User $user): bool
////    {
////        // [FIX] استفاده از Accessor جدید
////        return $user->researchTeams()->wherePivot('role', 'admin')->exists() || $user->manager_of_calibration;
////    }
////
////    /**
////     * [CORRECTED] Determine whether the user can update the model.
////     */
////    public function update(User $user, Equipment $equipment): bool
////    {
////        // منطق به‌روزرسانی مانند مشاهده است
////        return $this->view($user, $equipment);
////    }
////
////    /**
////     * [CORRECTED] Determine whether the user can delete the model.
////     */
////    public function delete(User $user, Equipment $equipment): bool
////    {
////        // منطق حذف مانند مشاهده است
////        return $this->view($user, $equipment);
////    }
////}
//
//
//namespace App\Policies;
//
//use App\Models\Equipment;
//use App\Models\User;
//use App\Models\ResearchTeam;
//
//class EquipmentPolicy
//{
//    /**
//     * Perform pre-authorization checks.
//     */
//    public function before(User $user, string $ability): bool|null
//    {
//        if ($user->hasRole('super_admin')) {
//            return true;
//        }
//        return null;
//    }
//
//    /**
//     * Determine whether the user can view the equipment management page.
//     */
//    public function viewAny(User $user): bool
//    {
//        // کاربر می‌تواند صفحه را ببیند اگر مدیر حداقل یک تیم باشد یا مسئول کالیبراسیون حداقل یک تیم باشد.
//        return $user->researchTeams()->wherePivot('role', 'admin')->exists()
//            || ResearchTeam::where('calibration_manager_id', $user->id)->exists();
//    }
//
//    /**
//     * Determine whether the user can view the model.
//     */
//    public function view(User $user, Equipment $equipment): bool
//    {
//        // اگر تجهیز مستقل است، فقط مدیر (مالک) آن می‌تواند آن را ببیند.
//        if (is_null($equipment->research_team_id)) {
//            return $user->id === $equipment->manager_id;
//        }
//
//        $team = $equipment->researchTeam;
//
//        // 1. آیا کاربر، مدیر این تیم است؟
//        if ($team->users()->where('user_id', $user->id)->wherePivot('role', 'admin')->exists()) {
//            return true;
//        }
//
//        // 2. آیا کاربر، مسئول کالیبراسیون این تیم است؟
//        if ($user->id === $team->calibration_manager_id) {
//            return true;
//        }
//
//        return false;
//    }
//
//    /**
//     * Determine whether the user can create models.
//     */
//    public function create(User $user): bool
//    {
//        // کاربر می‌تواند تجهیز جدید ایجاد کند اگر:
//        // 1. مدیر حداقل یک تیم باشد.
//        // 2. یا به عنوان مسئول کالیبراسیون برای حداقل یک تیم معرفی شده باشد.
//        return $user->researchTeams()->wherePivot('role', 'admin')->exists()
//            || ResearchTeam::where('calibration_manager_id', $user->id)->exists();
//    }
//
//    /**
//     * Determine whether the user can update the model.
//     */
//    public function update(User $user, Equipment $equipment): bool
//    {
//        return $this->view($user, $equipment);
//    }
//
//    /**
//     * Determine whether the user can delete the model.
//     */
//    public function delete(User $user, Equipment $equipment): bool
//    {
//        return $this->view($user, $equipment);
//    }
//}


namespace App\Policies;

use App\Models\Equipment;
use App\Models\User;
use App\Models\ResearchTeam;

class EquipmentPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->hasRole('super_admin')) {
            return true;
        }
        return null;
    }

    /**
     * [REFACTORED] Determine whether the user can view the equipment management page.
     */
    public function viewAny(User $user): bool
    {
        // A user can view the page if they are an admin of at least one team,
        // or they have the team-specific calibration manager role for at least one team.
        if ($user->researchTeams()->wherePivot('role', 'admin')->exists()) {
            return true;
        }

        foreach ($user->researchTeams as $team) {
            if ($user->hasRole("calibration_manager-Team-{$team->id}")) {
                return true;
            }
        }

        return false;
    }

    /**
     * [REFACTORED] Determine whether the user can view a specific equipment model.
     */
    public function view(User $user, Equipment $equipment): bool
    {
        // Deny if the equipment is not linked to a team.
        if (is_null($equipment->research_team_id)) {
            return false;
        }

        $team = $equipment->researchTeam;

        // 1. Is the user an admin of this specific team?
        if ($user->researchTeams()->where('research_team_id', $team->id)->wherePivot('role', 'admin')->exists()) {
            return true;
        }

        // 2. Does the user have the designated calibration manager role for this specific team?
        return $user->hasRole("calibration_manager-Team-{$team->id}");
    }

    /**
     * [REFACTORED] Determine whether the user can create new equipment.
     */
    public function create(User $user): bool
    {
        // The logic is the same as viewAny: if they can manage any team's equipment, they can create new ones.
        return $this->viewAny($user);
    }

    /**
     * [REFACTORED] Determine whether the user can update the equipment model.
     */
    public function update(User $user, Equipment $equipment): bool
    {
        // The logic for updating is the same as for viewing a specific item.
        return $this->view($user, $equipment);
    }

    /**
     * [REFACTORED] Determine whether the user can delete the equipment model.
     */
    public function delete(User $user, Equipment $equipment): bool
    {
        // The logic for deleting is the same as for viewing a specific item.
        return $this->view($user, $equipment);
    }
}

