<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\Response;

class FinancialPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user): bool|null
    {
        if ($user->hasRole('super_admin')) {
            return true;
        }
        return null;
    }

    /**
     * Determine whether the user can view the financial management module.
     */
    public function viewAny(User $user): bool
    {
        if ($user->researchTeams()->wherePivot('role', 'admin')->exists()) {
            return true;

        }
        // 1. Users with general roles that should always have access.
        if ($user->hasAnyRole(['monitoring_user', 'institution_admin', 'team_manager'])) {
            return true;
        }

        // 2. Check if the user is a purchasing manager in ANY of their teams.
        foreach ($user->researchTeams as $team) {
            if ($user->hasRole("purchasing_manager-Team-{$team->id}")) {
                return true; // Grant access if they have the role in at least one team.
            }


        }
        return false;
    }
}
