<?php

namespace App\Policies;

use App\Models\Institution;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class InstitutionPolicy
{
    /**
     * Determine whether the user can view any models.
     * این متد مشخص می‌کند چه کسی اجازه دیدن لیست نهادها را دارد.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasRole('super_admin') || $user->hasRole('monitoring_user');
    }

    /**
     * Determine whether the user can create models.
     * این متد مشخص می‌کند چه کسی اجازه ایجاد یک نهاد جدید را دارد.
     */
    public function create(User $user): bool
    {
        return $user->hasRole('super_admin') || $user->hasRole('monitoring_user');
    }

    /**
     * Determine whether the user can update the model.
     * این متد مشخص می‌کند چه کسی اجازه ویرایش یک نهاد را دارد.
     */
    public function update(User $user, Institution $institution): bool
    {
        return $user->hasRole('super_admin') || $user->hasRole('monitoring_user');
    }

    /**
     * Determine whether the user can delete the model.
     * این متد مشخص می‌کند چه کسی اجازه حذف یک نهاد را دارد.
     */
    public function delete(User $user, Institution $institution): bool
    {
        return $user->hasRole('super_admin') || $user->hasRole('monitoring_user');
    }
}
