<?php

namespace App\Policies;

use App\Models\Project;
use App\Models\ProjectAnnouncement;
use App\Models\User;

class ProjectAnnouncementPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->hasRole('super_admin')) {
            return true;
        }
        return null;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user, Project $project): bool
    {
        // فقط مالک طرح می‌تواند اطلاعیه جدید ایجاد کند
        return $user->id === $project->owner_id;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, ProjectAnnouncement $announcement): bool
    {
        // فقط مالک طرح می‌تواند اطلاعیه را ویرایش یا سنجاق کند
        return $user->id === $announcement->project->owner_id;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, ProjectAnnouncement $announcement): bool
    {
        // فقط مالک طرح می‌تواند اطلاعیه را حذف کند
        return $user->id === $announcement->project->owner_id;
    }
}
