<?php
//
//namespace App\Policies;
//
//use App\Models\PurchaseRequest;
//use App\Models\User;
//use Illuminate\Auth\Access\Response;
//
//class PurchaseRequestPolicy
//{
//    public function before(User $user): bool|null
//    {
//            if ($user->hasRole('super_admin')) {
//            return true;
//        }
//        return null;
//    }
//
//    /**
//     * [NEW] Determine whether the user can confirm supplier responses for a request.
//     */
//    public function confirmResponses(User $user, PurchaseRequest $purchaseRequest): bool
//    {
////        // Allow access if the user has the system-wide purchasing manager role.
////        if ($user->hasRole('purchasing_manager')) {
////            return true;
////        }
////        // If the request is not linked to a project, deny access.
////        if (!$purchaseRequest->project || !$purchaseRequest->project->researchTeam) {
////            return false;
////        }
////
////        // Check if the user is an admin of the research team associated with the project.
////        return $user->researchTeams()->where('research_team_id', $purchaseRequest->project->research_team_id)
////            ->where('role', 'admin')
////            ->exists();
//        // 1. Allow if the user has the specific permission.
//        if ($user->can('purchase-request-finalize-offers')) {
//            return true;
//        }
//
//        // 2. Deny if the request is not linked to a project.
//        if (!$purchaseRequest->project || !$purchaseRequest->project->researchTeam) {
//            return false;
//        }
//
//        // 3. Allow if the user is an admin of the project's research team.
//        return $user->researchTeams()
//            ->where('research_teams.id', $purchaseRequest->project->research_team_id)
//            ->wherePivot('role', 'admin')
//            ->exists();
//
//    }
//    /**
//     * [REWRITTEN] Determine whether the user can view supplier responses for a request.
//     */
//    public function viewResponses(User $user, PurchaseRequest $purchaseRequest): bool
//    {
//        // Allow access if the user has the system-wide purchasing manager role.
//        if ($user->hasRole('purchasing_manager')) {
//            return true;
//        }
//
//        // If the request is not linked to a project, deny access for other roles.
//        if (!$purchaseRequest->project || !$purchaseRequest->project->researchTeam) {
//            return false;
//        }
//
//        // Allow access if the user is an admin of the research team associated with the project.
//        return $user->researchTeams()->where('research_team_id', $purchaseRequest->project->research_team_id)
//            ->where('role', 'admin')
//            ->exists();
//    }
//
//    /**
//     * Determine whether the user can view the approval queue.
//     * این متد جدید، قانون دسترسی برای مشاهده لینک "صفحه تاییدها" را تعریف می‌کند.
//     */
//    public function viewApprovalQueue(User $user): bool
//    {
//        // کاربر فقط در صورتی می‌تواند این صفحه را ببیند که حداقل یک درخواست در انتظار تایید داشته باشد.
//        return PurchaseRequest::where('approver_id', $user->id)
//            ->where('status', 'pending_approval')
//            ->exists();
//    }
//
//    public function viewAny(User $user): bool
//    {
//        // فقط نقش‌های مدیریتی و تحقیقاتی می‌توانند این صفحه را ببینند.
//        return $user->hasRole('monitoring_user')
//            || $user->hasRole('institution_admin')
//            || $user->hasRole('researcher')
//            || $user->projectsAsCollaborator()->exists();
//
//    }
//
//    /**
//     * Determine whether the user can update the model.
//     */
////    public function update(User $user, PurchaseRequest $purchaseRequest): bool
////    {
////        // کاربر فقط در صورتی می‌تواند ویرایش کند که درخواست‌کننده اصلی باشد
////        // و وضعیت درخواست هنوز در مراحل اولیه باشد.
////        return $user->id === $purchaseRequest->requester_id &&
////            in_array($purchaseRequest->status, ['pending_approval', 'pending_merchant']);
////    }
//
//    public function update(User $user, PurchaseRequest $purchaseRequest): bool
//    {
//        // سناریو اول: اگر درخواست در انتظار تایید مالک طرح است
//        if ($purchaseRequest->status === 'pending_approval') {
//            // فقط درخواست‌کننده اصلی می‌تواند آن را ویرایش کند
//            return $user->id === $purchaseRequest->requester_id;
//        }
//
//        // سناریو دوم: اگر درخواست توسط مالک تایید شده و در انتظار بازرگان است
//        if ($purchaseRequest->status === 'pending_merchant') {
//            // فقط مالک طرح (که همان تایید کننده است) می‌تواند آن را ویرایش کند
//            return $user->id === $purchaseRequest->approver_id;
//        }
//
//        // در تمام وضعیت‌های دیگر (مانند سفارش داده شده، دریافت شده، رد شده)،
//        // هیچکس اجازه ویرایش ندارد.
//        return false;
//    }
//
//    /**
//     * Determine whether the user can delete the model.
//     */
//    public function delete(User $user, PurchaseRequest $purchaseRequest): bool
//    {
//        // قوانین حذف معمولاً مشابه قوانین ویرایش است.
//        return $this->update($user, $purchaseRequest);
//    }
//}
//


namespace App\Policies;

use App\Models\PurchaseRequest;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class PurchaseRequestPolicy
{
    public function before(User $user): bool|null
    {
        if ($user->hasRole('super_admin')) {
            return true;
        }
        return null;
    }

    /**
     * [REFACTORED] Determine whether the user can view any purchase requests.
     */
    public function viewAny(User $user): bool
    {
        // General administrative roles can always view the list.
        if ($user->hasAnyRole(['monitoring_user', 'institution_admin'])) {
            return true;
        }

        // Check if the user is a purchasing manager in ANY of their teams.
        foreach ($user->researchTeams as $team) {
            if ($user->hasRole("purchasing_manager-Team-{$team->id}")) {
                return true; // Grant access if they have the role in at least one team.
            }
        }

        // Allow if the user is a collaborator on any project.
        if ($user->projectsAsCollaborator()->exists()) {
            return true;
        }

        return false;
    }

    /**
     * [REFACTORED] Determine whether the user can view supplier responses for a request.
     */
    public function viewResponses(User $user, PurchaseRequest $purchaseRequest): bool
    {
        // Deny if the request is not linked to a project or team.
        if (!$purchaseRequest->project || !$purchaseRequest->project->research_team_id) {
            return false;
        }

        $teamId = $purchaseRequest->project->research_team_id;

        // Allow access if the user is the purchasing manager for THIS specific team.
        if ($user->hasRole("purchasing_manager-Team-{$teamId}")) {
            return true;
        }

        // Allow access if the user is an admin of the research team associated with the project.
        return $user->researchTeams()->where('research_team_id', $teamId)
            ->where('role', 'admin')
            ->exists();
    }

    /**
     * [REFACTORED] Determine whether the user can confirm supplier responses for a request.
     */
    public function confirmResponses(User $user, PurchaseRequest $purchaseRequest): bool
    {
        // The logic is the same as viewing responses.
        return $this->viewResponses($user, $purchaseRequest);
    }

    /**
     * Determine whether the user can view the approval queue.
     */
    public function viewApprovalQueue(User $user): bool
    {
        // This logic remains correct as it's based on the user being a direct approver.
        return PurchaseRequest::where('approver_id', $user->id)
            ->where('status', 'pending_approval')
            ->exists();
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, PurchaseRequest $purchaseRequest): bool
    {
        // Deny if the request is not linked to a project or team.
        if (!$purchaseRequest->project || !$purchaseRequest->project->research_team_id) {
            return false;
        }
        $teamId = $purchaseRequest->project->research_team_id;

        // Allow the purchasing manager of the specific team to edit when pending merchant responses.
        if ($purchaseRequest->status === 'pending_merchant' && $user->hasRole("purchasing_manager-Team-{$teamId}")) {
            return true;
        }

        // The original requester can edit when it's pending their manager's approval.
        if ($purchaseRequest->status === 'pending_approval' && $user->id === $purchaseRequest->requester_id) {
            return true;
        }

        // The project owner (approver) can also edit when it's pending merchant responses.
        if ($purchaseRequest->status === 'pending_merchant' && $user->id === $purchaseRequest->approver_id) {
            return true;
        }

        return false;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, PurchaseRequest $purchaseRequest): bool
    {
        // Deletion should only be possible in the very early stages.
        return $purchaseRequest->status === 'pending_approval' && $user->id === $purchaseRequest->requester_id;
    }
}
