<?php

namespace App\Policies;

use App\Models\InventoryConsumptionRequest;
use App\Models\User;
use App\Models\Project;

class WarehousePolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->hasRole('super_admin')) {
            return true;
        }
        return null;
    }

    /**
     * Determine whether the user can process (approve or reject) a warehouse request.
     * این متد بررسی می‌کند که آیا کاربر، مسئول انبار یا مالک طرح مربوط به این درخواست است یا خیر.
     */
    /**
     * [REWRITTEN] Determine whether the user can process (approve or reject) a warehouse request
     * with conditional logic based on the requester.
     */
    public function process(User $user, InventoryConsumptionRequest $request): bool
    {
        $project = $request->project;
        $requester = $request->requester;

        // اگر درخواست‌دهنده، مسئول گردش انبار باشد یا دسترسی مستقیم مدیریت انبار را داشته باشد...
        if ($requester && ($requester->id === $project->warehouse_manager_id || $requester->hasDirectPermissionInProject('warehouse-manage-requests', $project))) {
            // ...فقط مالک طرح می‌تواند آن را پردازش کند.
            return $user->id === $project->owner_id;
        }

        // در غیر این صورت (اگر یک کاربر عادی درخواست را ثبت کرده باشد)،
        // از منطق قبلی استفاده می‌کنیم:

        // 1. مالک طرح می‌تواند پردازش کند.
        if ($user->id === $project->owner_id) {
            return true;
        }

        // 2. مسئول گردش انبار می‌تواند پردازش کند.
        if ($user->id === $project->warehouse_manager_id) {
            return true;
        }

        // 3. کاربر با دسترسی مستقیم می‌تواند پردازش کند.
        return $user->hasDirectPermissionInProject('warehouse-manage-requests', $project);
    }
}
