<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use App\Models\User;
use App\Models\InventoryTransfer; // این خط اضافه می‌شود
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use App\Policies\WarehousePolicy;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        \App\Models\Institution::class => \App\Policies\InstitutionPolicy::class,
        \App\Models\Project::class => \App\Policies\ProjectPolicy::class,
        \App\Models\InventoryItem::class => \App\Policies\InventoryItemPolicy::class, // <-- این خط اضافه شود
        \App\Models\LabNotebookEntry::class => \App\Policies\LabNotebookEntryPolicy::class,
        \App\Models\PurchaseRequest::class => \App\Policies\PurchaseRequestPolicy::class,
        \App\Models\InventoryConsumptionRequest::class => \App\Policies\WarehousePolicy::class,
        \App\Models\Task::class => \App\Policies\TaskPolicy::class,
        \App\Models\ProjectAnnouncement::class => \App\Policies\ProjectAnnouncementPolicy::class,
        \App\Models\InventoryP::class => \App\Policies\ProjectPolicy::class,


    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {


        $this->registerPolicies();

        // این Gate بررسی می‌کند که آیا کاربر مدیر یک سازمان است یا خیر
        Gate::define('manage-institution', function (User $user) {
            // ما بررسی می‌کنیم که آیا کاربر در جدول عضویت‌ها، نقشی برابر با 'admin' دارد یا خیر
            return $user->institutionMemberships()->where('role', 'admin')->exists();
        });

        // این Gate بررسی می‌کند که آیا کاربر حواله‌ای برای تایید دارد یا خیر
        Gate::define('view-transfer-approvals', function (User $user) {
            // ابتدا تمام تیم‌هایی را که کاربر مدیر آن‌هاست، پیدا می‌کنیم
            $managedTeamIds = $user->researchTeams()->wherePivot('role', 'admin')->pluck('research_teams.id');

            if ($managedTeamIds->isEmpty()) {
                return false;
            }

            // سپس بررسی می‌کنیم که آیا حواله‌ای در انتظار تایید برای این تیم‌ها وجود دارد یا خیر
            return InventoryTransfer::whereIn('destination_team_id', $managedTeamIds)
                ->where('status', 'pending_receipt')
                ->exists();
        });

//        // این Gate بررسی می‌کند که آیا کاربر، مدیر کل سیستم است یا خیر
//        Gate::define('view-admin-panel', function (User $user) {
//            return $user->hasSystemRole('super_admin');
//        });

        // این Gate بررسی می‌کند که آیا کاربر، مدیر کل سیستم است یا خیر
        Gate::define('view-admin-panel', function (User $user) {
            return $user->hasRole('super_admin');
        });



    }
}
