<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('institutions', function (Blueprint $table) {
            $table->id();

            // اطلاعات اصلی نهاد
            $table->string('name');
            $table->string('type')->nullable(); // نوع نهاد (مثلاً: دانشگاه، پژوهشگاه)

            // اطلاعات تماس نهاد
            $table->text('address')->nullable();
            $table->string('phone', 50)->nullable();
            $table->string('website')->nullable();

            // شناسه کاربر ارشد یا رابط این نهاد در سیستم
            // این یک کلید خارجی به جدول کاربران است.
            $table->foreignId('contact_person_id')->nullable()->constrained('users')->onDelete('set null');

            // وضعیت نهاد (فعال، غیرفعال، در انتظار تایید)
            $table->string('status', 50)->default('active');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('institutions');
    }
};
