<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('roles', function (Blueprint $table) {
            $table->id();

            // نام فنی نقش (برای استفاده در کد)
            $table->string('name')->unique();

            // نام نمایشی نقش (برای نمایش در رابط کاربری)
            $table->string('display_name');

            // حوزه اعتبار نقش (سیستمی یا وابسته به نهاد)
            $table->string('scope', 50)->default('institution');

            // توضیحات اختیاری در مورد نقش
            $table->text('description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('roles');
    }
};
