<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('role_user', function (Blueprint $table) {
            $table->id();

            // شناسه کاربر
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // شناسه نقش
            $table->foreignId('role_id')->constrained()->onDelete('cascade');

            // شناسه نهادی که کاربر در آن، این نقش را دارد (اختیاری)
            $table->foreignId('institution_id')->nullable()->constrained()->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('role_user');
    }
};
