<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();

            // اطلاعات اصلی طرح
            $table->string('title');
            $table->enum('type', ['approved', 'thesis', 'personal']);
            $table->string('status', 50)->default('pending');

            // شناسه‌های ارتباطی
            $table->foreignId('institution_id')->constrained()->onDelete('cascade');
            $table->foreignId('owner_id')->constrained('users')->onDelete('cascade');

            // جزئیات مالی و زمانی
            $table->decimal('budget', 15, 2)->nullable();
            $table->string('registration_code')->nullable();
            $table->date('approval_date')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();

            // توضیحات تکمیلی
            $table->text('description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
