<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_user', function (Blueprint $table) {
            $table->id();

            // شناسه طرح
            $table->foreignId('project_id')->constrained()->onDelete('cascade');

            // شناسه کاربر
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // نقش کاربر در این پروژه خاص
            $table->string('project_role');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_user');
    }
};
