<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_protocol', function (Blueprint $table) {
            $table->id();

            // شناسه طرح
            $table->foreignId('project_id')->constrained()->onDelete('cascade');

            // شناسه پروتکل
            $table->foreignId('protocol_id')->constrained()->onDelete('cascade');

            $table->timestamps();

            // جلوگیری از ثبت یک پروتکل تکراری برای یک طرح
            $table->unique(['project_id', 'protocol_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_protocol');
    }
};
