<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lab_notebook_entries', function (Blueprint $table) {
            $table->id();

            // عنوان یادداشت
            $table->string('title');

            // محتوای اصلی یادداشت
            $table->longText('body')->nullable();

            // تاریخ انجام آزمایش یا ثبت یادداشت
            $table->date('entry_date');

            // شناسه‌های ارتباطی
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // وضعیت یادداشت (پیش‌نویس، ثبت نهایی، قفل شده)
            $table->string('status', 50)->default('draft');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lab_notebook_entries');
    }
};
