<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attachments', function (Blueprint $table) {
            $table->id();

            // شناسه یادداشتی که این پیوست به آن تعلق دارد
            $table->foreignId('lab_notebook_entry_id')->constrained()->onDelete('cascade');

            // اطلاعات فایل
            $table->string('file_name');           // نام اصلی فایل
            $table->string('file_path');           // مسیر ذخیره‌سازی فایل روی سرور
            $table->unsignedInteger('file_size');  // حجم فایل به بایت
            $table->string('mime_type');           // نوع فایل (e.g., 'image/jpeg')

            // توضیحات اختیاری برای فایل
            $table->text('caption')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attachments');
    }
};
