<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('storage_locations', function (Blueprint $table) {
            $table->id();

            // نام مکان
            $table->string('name');

            // نوع مکان
            $table->string('type');

            // شناسه مکان والد (برای ایجاد ساختار درختی)
            $table->foreignId('parent_id')->nullable()->constrained('storage_locations')->onDelete('cascade');

            // شناسه‌ی نهادی که این مکان به آن تعلق دارد
            $table->foreignId('institution_id')->constrained()->onDelete('cascade');

            // توضیحات اختیاری
            $table->text('description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('storage_locations');
    }
};
