<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_items', function (Blueprint $table) {
            $table->id();

            // اطلاعات اصلی قلم
            $table->string('name');
            $table->string('sku')->nullable()->unique(); // کد منحصر به فرد داخلی انبار
            $table->text('description')->nullable();

            // نوع قلم
            $table->string('item_type');

            // مقدار و واحد
            $table->decimal('quantity', 10, 4);
            $table->string('unit', 50);

            // تاریخ‌ها
            $table->date('expiration_date')->nullable();
            $table->date('received_date')->nullable();

            // شناسه‌های ارتباطی
            $table->foreignId('location_id')->nullable()->constrained('storage_locations')->onDelete('set null');
            $table->foreignId('institution_id')->constrained()->onDelete('cascade');
            $table->foreignId('owner_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('project_id')->nullable()->constrained()->onDelete('set null');

            // ما این ستون را اضافه می‌کنیم اما جدول آن را بعداً می‌سازیم
            $table->unsignedBigInteger('supplier_id')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_items');
    }
};
