<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suppliers', function (Blueprint $table) {
            $table->id();

            // اطلاعات اصلی شرکت
            $table->string('company_name')->unique();
            $table->string('contact_person')->nullable();

            // اطلاعات تماس
            $table->string('email')->nullable();
            $table->string('phone', 50)->nullable();
            $table->text('address')->nullable();
            $table->string('website')->nullable();

            // شناسه‌ی نهادی که این تأمین‌کننده را ثبت کرده (اختیاری)
            $table->foreignId('institution_id')->nullable()->constrained()->onDelete('set null');

            // وضعیت
            $table->string('status', 50)->default('active');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suppliers');
    }
};
