<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_requests', function (Blueprint $table) {
            $table->id();

            // شناسه درخواست (کد قابل خواندن برای پیگیری)
            $table->string('request_code')->unique();

            // شناسه‌های ارتباطی
            $table->foreignId('requester_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('institution_id')->constrained()->onDelete('cascade');
            $table->foreignId('project_id')->nullable()->constrained()->onDelete('set null');

            // وضعیت درخواست
            $table->string('status', 50)->default('pending');

            // توضیحات و اولویت
            $table->text('notes')->nullable();
            $table->string('priority', 50)->default('normal');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_requests');
    }
};
