<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_request_items', function (Blueprint $table) {
            $table->id();

            // شناسه درخواستی که این قلم به آن تعلق دارد
            $table->foreignId('purchase_request_id')->constrained()->onDelete('cascade');

            // اطلاعات قلم درخواستی
            $table->string('item_name');
            $table->foreignId('supplier_id')->nullable()->constrained()->onDelete('set null');
            $table->string('catalog_number')->nullable();

            // مقدار درخواستی
            $table->decimal('quantity', 10, 4);
            $table->string('unit', 50);

            // قیمت تخمینی
            $table->decimal('estimated_cost_per_unit', 15, 2)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_request_items');
    }
};
