<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('institutions', function (Blueprint $table) {
            // ما یک ستون جدید برای کد سه حرفی و منحصر به فرد نهاد اضافه می‌کنیم
            // این ستون بعد از ستون 'name' قرار می‌گیرد.
            $table->string('code', 3)->unique()->nullable()->after('name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('institutions', function (Blueprint $table) {
            $table->dropColumn('code');
        });
    }
};
