<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lab_notebook_entry_versions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lab_notebook_entry_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null'); // کاربری که این نسخه را ایجاد کرده
            $table->unsignedInteger('version');
            $table->string('title');
            $table->longText('body');
            $table->date('entry_date');
            $table->timestamps(); // زمان ایجاد این نسخه
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lab_notebook_entry_versions');
    }
};
