<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lab_notebook_signatures', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lab_notebook_entry_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // The user who signed
            $table->timestamp('signed_at');
            // You can add more fields here later, like a cryptographic hash of the content
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lab_notebook_signatures');
    }
};
