<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchase_request_items', function (Blueprint $table) {
            // این ستون‌ها پاسخ بازرگان را ذخیره می‌کنند
            $table->boolean('is_accepted')->nullable()->after('description');
            $table->decimal('supplied_quantity', 10, 4)->nullable()->after('is_accepted');
            $table->decimal('price_per_unit', 15, 2)->nullable()->after('supplied_quantity');
            $table->text('supplier_notes')->nullable()->after('price_per_unit');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchase_request_items', function (Blueprint $table) {
            $table->dropColumn(['is_accepted', 'supplied_quantity', 'price_per_unit', 'supplier_notes']);
        });
    }
};
